/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.STPProcessEvent;
import com.cisco.pt.ipc.events.STPProcessEventListener;
import com.cisco.pt.ipc.sim.process.STPProcess;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STPProcessEventRegistry
extends IPCEventRegistry {
    protected Set<STPProcessEventListener> globalListeners = new HashSet<STPProcessEventListener>();
    protected Map<String, Set<STPProcessEventListener>> specificObjectListeners = new HashMap<String, Set<STPProcessEventListener>>();
    private static Log logger = LogFactory.getLog(STPProcessEventRegistry.class);

    public STPProcessEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "StpProcess";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        STPProcessEvent evt = null;
        if (eventName.equalsIgnoreCase("rootChanged")) {
            evt = new STPProcessEvent.RootChanged(event);
        } else if (eventName.equalsIgnoreCase("stpPortStateChanged")) {
            evt = new STPProcessEvent.StpPortStateChanged(event);
        } else if (eventName.equalsIgnoreCase("rstpPortStateChanged")) {
            evt = new STPProcessEvent.RstpPortStateChanged(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (STPProcessEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<STPProcessEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (STPProcessEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(STPProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("rootChanged");
                this.register("stpPortStateChanged");
                this.register("rstpPortStateChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(STPProcessEventListener listener, STPProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<STPProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<STPProcessEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "rootChanged");
                this.register(uuid, "stpPortStateChanged");
                this.register(uuid, "rstpPortStateChanged");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(STPProcessEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("rootChanged");
                this.deregister("stpPortStateChanged");
                this.deregister("rstpPortStateChanged");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(STPProcessEventListener listener, STPProcess objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<STPProcessEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "rootChanged");
            this.deregister(uuid, "stpPortStateChanged");
            this.deregister(uuid, "rstpPortStateChanged");
            specificListeners.remove(listener);
        }
    }

    public void addListener(STPProcessEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(STPProcessEventListener listener, STPProcess objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(STPProcessEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(STPProcessEventListener listener, STPProcess objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

